#ifndef __FS_HW_H
#define __FS_HW_H

/*
*      THIS FILE 'fs_hw.h' IS THE FILE SYSTEM HARDWARE FILE.
*      IN THIS FILE ARE THE DEFINES FOR THE HARDWARE PLATFORM WHERE THE
*      FILE SYSTEM IS RUNNING ON. THE DEFINES ARE FOR THE HARDWARE INTERFACE
*      TO THE FLASH CHIP.
*/
/*
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved */


#define     TRUE                            1
#define     FALSE                           0


#define     uint16                          unsigned short
#define     WORD_PTR                        uint16 *
#define     uint32                          unsigned long
#define     LONG_PTR                        uint32 *
#define     int32                           signed long

#define     uint8                           unsigned char

#define     LINK_SIZE                       16
#define     SPI_SLAVE_SELECT                0x0008
#define     SPI_CLOCK                       0x0004
#define     GPIO_BASE_ADDRESS               0x1FFE74
#define     GPIOC_PER_OFFSET                0
#define     GPIOC_DIR_OFFSET                1
#define     GPIOC_DATA_OFFSET               2
#define     GPIOC_PULLUP_OFFSET             3

/* THE SS_PER_REG IS THE ADDRESS TO CONFIGURE THE PORT LINE TO USE THE UNDERLAYING
   PERIPHERAL OR USE IT AS A SIMPLE PORT LINE  */

#define     SS_DATA_REG                     (GPIO_BASE_ADDRESS + GPIOC_DATA_OFFSET)
#define     SS_DIR_REG                      (GPIO_BASE_ADDRESS + GPIOC_DIR_OFFSET)
#define     SS_PER_REG                      (GPIO_BASE_ADDRESS + GPIOC_PER_OFFSET)

#define     CLK_DATA_REG                    (GPIO_BASE_ADDRESS + GPIOC_DATA_OFFSET)
#define     CLK_DIR_REG                     (GPIO_BASE_ADDRESS + GPIOC_DIR_OFFSET)
#define     CLK_PER_REG                     (GPIO_BASE_ADDRESS + GPIOC_PER_OFFSET)

/* THIS IS THE BIT MASK FOR THE ATMEL FLASH TO DETERMINE IF THE FLASH IS READY OR BUSY */
#define     FLASH_BUSY                      0x80




#define     BASE_SPI_ADDRESS                0x1FFFE8
#define     SPI_STATUS_OFFSET               0
#define     SPI_CONTROL_OFFSET              1
#define     SPI_RECEIVE_OFFSET              2
#define     SPI_TRANSMIT_OFFSET             3

#define     SPI_STATUS_REG                  (BASE_SPI_ADDRESS + SPI_STATUS_OFFSET)
#define     SPI_CONTROL_REG                 (BASE_SPI_ADDRESS + SPI_CONTROL_OFFSET)
#define     SPI_RX_REG                      (BASE_SPI_ADDRESS + SPI_RECEIVE_OFFSET)
#define     SPI_TX_REG                      (BASE_SPI_ADDRESS + SPI_TRANSMIT_OFFSET)



#define     SPI_ENABLE                      0x0020
#define     SPI_RECEIVER_FULL               0x0008
#define     SPI_TRANSMIT_EMPTY              0x0001

#define     SPI_CONFIG1                     0x21c0
#define     SPI_CONFIG2                     0x0007 /* 8 bit data */




void        file_outw( uint32 address, uint16 data );
uint16      file_inw( uint32 address );
void        Fs_Spi_Transmit_Ready(void);
void        Fs_Spi_Receive_Ready(void);
void        Query_Flash_Status(void);
uint16      Send_Flash_Command(uint16 command,uint8 * data_pointer);
void        Send_Byte(uint16 data);
uint16      Get_Byte(void);

#endif /*  __FS_HW_H */
