#ifndef __FS_FLASH_H
#define __FS_FLASH_H

/*
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved */
#define     TRUE                            1
#define     FALSE                           0

#define     uint16                          unsigned short
#define     WORD_PTR                        uint16 *
#define     uint32                          unsigned long
#define     LONG_PTR                        uint32 *
#define     int32                           signed long

#define     uint8                           unsigned char

#define POLLING

#ifndef POLLING
    #define FLASH_TASK_SLEEP     Task_Sleep(1);
#endif



/* #define   SPI_MODE1 */

#ifdef SPI_MODE1
#define     STATUS_COMMAND                  0x57
#define     READ_CONTINUOUS_COMMAND         0x68
#define     READ_MAIN_MEMORY_COMMAND        0x52
#define     BUFFER1_READ_COMMAND            0x54
#define     BUFFER2_READ_COMMAND            0x56

#else
#define     STATUS_COMMAND                  0xD7
#define     READ_CONTINUOUS_COMMAND         0xE8
#define     READ_MAIN_MEMORY_COMMAND        0xD2
#define     BUFFER1_READ_COMMAND            0xD4
#define     BUFFER2_READ_COMMAND            0xD6
#endif

#define     BUFFER1_WRITE                   0x84
#define     BUFFER2_WRITE                   0x87
#define     BUFFER1_PROGRAM_ERASE           0x83
#define     BUFFER2_PROGRAM_ERASE           0x86
#define     BUFFER1_PROGRAM                 0x88
#define     BUFFER2_PROGRAM                 0x89
#define     PAGE_ERASE                      0x81
#define     BLOCK_ERASE                     0x50
#define     BUFFER1_WRITE_AND_PROGRAM       0x82
#define     BUFFER2_WRITE_AND_PROGRAM       0x85
#define     MEMORY_TO_BUFFER1               0x53
#define     MEMORY_TO_BUFFER2               0x55
#define     COMPARE_MEMORY_TO_BUFFER1       0x60
#define     COMPARE_MEMORY_TO_BUFFER2       0x61
#define     BUFFER1_REWRITE                 0x58
#define     BUFFER2_REWRITE                 0x59

#define     FLASH_BUSY                      0x80
#define     FLASH_COMP                      0x40

#define     DEVICE_FAIL                      0x1
#define     DEVICE_SUCCESS                   0x0


#define     FIRST_FILE_PAGE                0

enum FLASH_BUFFER_SIZE
{
   BUFFER_264 = 0,
   BUFFER_528,
   BUFFER_1056,
   BUFFER_2112
};

enum FLASH_BUFFER
{
   BUFF1 = 0,
   BUFF2
};
enum FLASH_SIZE
{
   SIZE_1_MEG   = 3,
   SIZE_2_MEG   = 5,
   SIZE_4_MEG   = 7,
   SIZE_8_MEG   = 9,
   SIZE_16_MEG  = 11,
   SIZE_32_MEG  = 13,
   SIZE_64_MEG  = 15,
   SIZE_128_MEG = 4,
   SIZE_256_MEG = 6,
   SIZE_512_MEG = 8,
   SIZE_1_GIG   = 10,
   SIZE_2_GIG   = 12,
   SIZE_4_GIG   = 14
};

void        Read_Flash(uint16 page_number,uint16 byte_location, uint8 * data_pointer,uint16 length);
uint16      sendFlashCommand(uint16 command,uint8 * data_pointer);
void        Send_Byte(uint16 data);
uint16      Get_Byte(void);
void        setupFlashAddress(uint8 * address, uint16 page_address, uint16 byte_address,enum FLASH_BUFFER_SIZE size);
uint16      flashBusyDelay(void);
uint16      FlashCompare(uint16 page_number);
uint32      Write_Flash_Data(uint16 page_number, uint16 byte_location, uint8 * data_pointer, uint16 data_size);
void        Move_Flash_To_Buffer(uint16 page_number);
void        Read_Buffer(uint16 byte_location,uint8 * data_pointer,uint16 length);
void        Write_Buffer(uint16 byte_location, uint8 * data_pointer, uint16 data_size);
void        Program_Buffer(uint16 page_number);
void        Erase_Page(uint16 page_number);
void        Refresh_Page(uint16 page_number);
void        Flash_Refresh(uint16 start_page, uint16 finish_page);

#endif /*  __FS_FLASH_H */
