#ifndef __FS_DRIVER_H
#define __FS_DRIVER_H
/*
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved */

#define     uint16                          unsigned short
#define     uint8                           unsigned char
#define     uint32                          unsigned long

#define     REFRESH_ENABLED
#define     WEAR_LEVEL_ENABLED

#ifdef REFRESH_ENABLED
	#include "fs_refresh.h"
    #define SECTOR_ERASE_COUNT(A)     Update_Bit_Disturb_Table(A);
#else
   #define SECTOR_ERASE_COUNT(A)
#endif

#ifdef WEAR_LEVEL_ENABLED
    uint32 Update_Erase_Count(uint16 page_number);
    #define PAGE_ERASE_COUNT(A,B)     A = Update_Erase_Count(B);
#else
   #define PAGE_ERASE_COUNT(A,B)     A = 0;
#endif


/*
*      THIS DEFINE IS TO DETERMINE THE MAX SIZE OF THE SECTOR ARRAY.
*      THIS VALUE IS USED FOR BIT DISTURB OF SECTORS
*      THE NUMBER OF ERASE CYCLES MUST BE TRACKED FOR EACH SECTOR.
*      WHEN THE THRESHOLD HAS BEEN REACHED THEN THE ENTIRE SECTOR
*      NEEDS TO BE REFRESHED. LISTED ARE THE SECTORS ON EACH PART
*      1   MEG  3
*      2   MEG  4
*      4   MEG  6
*      8   MEG  10
*      16  MEG  17
*      32  MEG  17
*      64  MEG  33
*      128 MEG  65
*      256 MEG  65
*
*/

#define         SECTOR_ARRAY_SIZE       65
#define         REFRESH_THRESHOLD       8000
#define         WEAR_THRESHOLD          5000

typedef struct FLASH_FILE_Info
{
    uint16 file_system_start;
    uint16 file_system_size;
    uint16 buffer;
    uint16 buffer_overhead;
    enum FLASH_BUFFER_SIZE buffer_size;
    enum FLASH_SIZE flash_size;
    uint16 percent_size;
}FLASH_FILE_Info;
#if  (defined(REFRESH_ENABLED)||defined(WEAR_LEVEL_ENABLED))
    typedef struct FLASH_STORAGE_Info
    {
        uint16 valid_data;
        uint16 wearCount;/* This is used to keep track of the number of times */
                         /* the WEAR_THRESHOLD has been excedded              */
        uint16 sector_array[SECTOR_ARRAY_SIZE];
    }FLASH_STORAGE_Info;
#endif

#ifdef          file_system_ram_c
    #define         EXTERN_FILE_SYSTEM_C
#else
    #define         EXTERN_FILE_SYSTEM_C       extern
#endif

EXTERN_FILE_SYSTEM_C        struct    FLASH_FILE_Info FLASH_FILE;
EXTERN_FILE_SYSTEM_C        uint16    g_format_percentage;

#if  (defined(REFRESH_ENABLED)||defined(WEAR_LEVEL_ENABLED))

    EXTERN_FILE_SYSTEM_C        struct    FLASH_STORAGE_Info FLASH_STORAGE;
#endif
#ifdef WEAR_LEVEL_ENABLED
    void Initialize_Erase_Count(void);
#endif

void    Fsd_Read_Data (uint16 block, uint8 * buff );
uint16 Translate_Block_Number(uint16 block, uint16 * start_address);
uint16  Fsd_Write_Data (uint16 block, uint8 * buff);
void    UpdateWearCount(void);

#endif  /* __FS_DRIVER_H  */

