

#ifndef __FLASH_CMDS_H
#define __FLASH_CMDS_H


void Read_Flash_Function(char * st);
void Read_Flash_Buffer(char * st);
void Refresh_Flash(char * st);
void cmd_write_buffer(char * st);
void flash_to_buffer(char * st);
void buffer_to_flash(char * st);

void Read_Sector_Count(char * st);
void Update_Sector_Count(char * st);
void Change_Flash_Type(char * st);
void Print_Flash_Type(uint16 flash_type);
void Get_Flash_Type(char * st);
void Clear_Sector_Array(char * st);
void Print_Sector_Boundries(char * st);
void Block_Translation(char * st);
void Cycle_Block(char * st);

void Format_Flash(char * st);
void  Erase_Flash(char * st);
void  Convert_Date(char * st);

void  File_Open(char * st);
void  File_Close(char * st);
void  File_Read(char * st);
void  File_Write(char * st);
void  File_Remove(char * st);
void  mkdir(char * st);
void Driver_Mount(char * st);
void Driver_Unmount(char * st);
void  File_Create(char * st);
void Dir_Read( char* strDirname );
void  File_Seek(char * st);
void  fatWriteFiles(char * st);
void  fatDeleteFiles(char * st);
void  fatWriteDirs(char * st);
void  fatDeleteDirs(char * st);
void  PrintDate(char * st);
#define FLASH_COMMANDS      {"flashread", Read_Flash_Function},\
                            {"buffread", Read_Flash_Buffer},\
                            {"flashref", Refresh_Flash},\
                            {"buffwrite", cmd_write_buffer},\
                            {"flash2buff",flash_to_buffer},\
                            {"buff2flash",buffer_to_flash},\
                            {"getsector", Read_Sector_Count},\
                            {"updatesect", Update_Sector_Count},\
                            {"newflash", Change_Flash_Type},\
                            {"flashtype", Get_Flash_Type},\
                            {"clrsect", Clear_Sector_Array},\
                            {"sectbound", Print_Sector_Boundries},\
                            {"blktrn", Block_Translation},\
                            {"cycle", Cycle_Block},\
                            {"erasepage", Erase_Flash},\
                            {"date", PrintDate},\
/* #define FILE_COMMANDS \   */ \
                            {"format", Format_Flash},\
                            {"fopen", File_Open},\
                            {"fclose", File_Close},\
                            {"fread", File_Read},\
                            {"fwrite", File_Write},\
                            {"fcreate", File_Create},\
                            {"fremove", File_Remove},\
                            {"mkdir", mkdir},\
                            {"mount", Driver_Mount},\
                            {"unmount", Driver_Unmount},\
                            {"dir", Dir_Read},\
                            {"lseek",File_Seek},\
                            {"cfiles",fatWriteFiles},\
                            {"dfiles",fatDeleteFiles},\
                            {"cdirs",fatWriteDirs},\
                            {"ddirs",fatDeleteDirs},
#endif
