#include "fs_hal.h"
#include "fs_flash.h"
#include "fs_driver.h"
#include "fs_refresh.h"


    #ifdef REFRESH_ENABLED
/*
//;*************************************************************************
//;_________________________________________________________________________
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved
//;_________________________________________________________________________
//;
//;     Filename            Update_Bit_Disturb_Table
//;
//;     Author:             DSP OS Inc.
//;
//;     Date:               07/28/2002
//;
//;     Inputs:             uint16 page_number
//;
//;     Outputs:            none
//;
//;     Description:        This function will update the sector erase count.
//;                         It will take into account which part is in use.
//;
//;     Cautions:           None
//;_________________________________________________________________________
//;     Revision History:
//;
//;     Version             Date    Modified By     Change Discription
//;     _______             ____    ___________     __________________
//;_________________________________________________________________________
//;************************************************************************* */

void Update_Bit_Disturb_Table(uint16 page_number)
{
    uint16 oddball_part = FALSE;
    uint16 pages_per_sector = 512;
    uint16 sector_number;

    sector_number = page_number>>9; /* DIVIDE BY 512 */
    switch (FLASH_FILE.flash_size)
    {

        case SIZE_32_MEG:
            /* pages_per_sector = 512;
            sector_number = page_number>>9; */ /* DIVIDE BY 512 */
            break;

        case SIZE_2_MEG:
        case SIZE_4_MEG:
        case SIZE_8_MEG:
            oddball_part = TRUE;
            /*pages_per_sector = 512;
            sector_number = page_number>>9; */ /* DIVIDE BY 512 */
            break;

        case SIZE_1_MEG:
        case SIZE_16_MEG:
        case SIZE_64_MEG:
        case SIZE_128_MEG:
        case SIZE_256_MEG:
            pages_per_sector = 256;
            sector_number = page_number>>8; /* DIVIDE BY 256 */
            break;
    }

    if (page_number > (pages_per_sector - 1))
    {
        if (oddball_part == TRUE)
        {
            sector_number = sector_number + 2;
        }
        else
        {
            sector_number = sector_number + 1;
        }
    }
    else
    {
        if (page_number > 7)
        {
            sector_number = 1;
        }
        if ((oddball_part == TRUE) &&(page_number >255))
        {
             sector_number = 2;
        }
    }
    FLASH_STORAGE.sector_array[sector_number]++;
}

/*
//;*************************************************************************
//;_________________________________________________________________________
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved
//;_________________________________________________________________________
//;
//;     Filename            Check_For_Refresh
//;
//;     Author:             DSP OS Inc.
//;
//;     Date:               07/28/2002
//;
//;     Inputs:             none
//;
//;     Outputs:            TRUE/FALSE
//;
//;     Description:        This function will loop through all of the sector
//;                         erase count table and check if any sector has gone
//;                         beyond the erase count limit without a refresh.
//;                         This function is called by the user to determine
//;                         when to call the Refresh_Sectors function.
//;
//;     Cautions:           None
//;_________________________________________________________________________
//;     Revision History:
//;
//;     Version             Date    Modified By     Change Discription
//;     _______             ____    ___________     __________________
//;_________________________________________________________________________
//;************************************************************************* */
uint16 Check_For_Refresh(void)
{
    uint16 i, refresh;
    refresh = FALSE;
    for (i = 0; i <= SECTOR_ARRAY_SIZE; i++)
    {
        if (FLASH_STORAGE.sector_array[i] >= REFRESH_THRESHOLD)
        {
            refresh = TRUE;
            break;
        }
     }
     return refresh;
}

/*
//;*************************************************************************
//;_________________________________________________________________________
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved
//;_________________________________________________________________________
//;
//;     Filename            Refresh_Sectors
//;
//;     Author:             DSP OS Inc.
//;
//;     Date:               07/28/2002
//;
//;     Inputs:             none
//;
//;     Outputs:            TRUE/FALSE
//;
//;     Description:        This function is called when it is determined a sector
//;                         has gone beyond its reccomended erase count.
//;                         It will rewrite all the pages within each sector
//;                         that needs to be refreshed. It will also reset the
//;                         sector erase count.
//;
//;     Cautions:           None
//;_________________________________________________________________________
//;     Revision History:
//;
//;     Version             Date    Modified By     Change Discription
//;     _______             ____    ___________     __________________
//;_________________________________________________________________________
//;************************************************************************* */
void Refresh_Sectors(void)
{
    uint16 sector,refresh;
    uint16 start_page,end_page;
    uint16 oddball_part = FALSE;
    uint16 pages_per_sector = 512;

    refresh = FALSE;
    for (sector = 0; sector < SECTOR_ARRAY_SIZE; sector++)
    {
        if (FLASH_STORAGE.sector_array[sector] >= REFRESH_THRESHOLD)
        {
            FLASH_STORAGE.sector_array[sector] = 0;
            /* NOW GENERATE THE BOUNDRY PAGES FOR THIS SECTOR */
            switch (FLASH_FILE.flash_size)
            {
                case SIZE_32_MEG:
                    /*pages_per_sector = 512; */
                    break;

                case SIZE_2_MEG:
                case SIZE_4_MEG:
                case SIZE_8_MEG:
                    oddball_part = TRUE;
                    /*pages_per_sector = 512; */
                    break;

                case SIZE_1_MEG:
                case SIZE_16_MEG:
                case SIZE_64_MEG:
                case SIZE_128_MEG:
                case SIZE_256_MEG:
                    pages_per_sector = 256;
                    break;
            }
            if (oddball_part == TRUE)
            {
                start_page = pages_per_sector*(sector - 2);
            }
            else
            {
                start_page = pages_per_sector*(sector - 1);
            }
            end_page = start_page + pages_per_sector - 1;
            if (sector == 0)
            {
                start_page = 0;
                end_page = 7;
            }
            if (sector == 1)
            {
                start_page = 8;
            }
            if (oddball_part == TRUE)
            {
                if (sector == 1)
                {
                    start_page = 8;
                    end_page = 255;
                }
                if (sector == 2)
                {
                    start_page = 256;
                    end_page = 511;
                }
            }
            Flash_Refresh(start_page, end_page);
        } /* END IF   FOR SECTOR NEEDS REFRESH */
    } /* END FOR LOOP */
}
/*
//;*************************************************************************
//;_________________________________________________________________________
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved
//;_________________________________________________________________________
//;
//;     Filename            Flash_Refresh
//;
//;     Author:             DSP OS Inc.
//;
//;     Date:               07/28/2002
//;
//;     Inputs:             uint16 start_page, end_page
//;
//;     Outputs:            none
//;
//;     Description:        This function refreshes all pages withing the start
//;                         and end page parameters.
//;
//;     Cautions:           None
//;_________________________________________________________________________
//;     Revision History:
//;
//;     Version             Date    Modified By     Change Discription
//;     _______             ____    ___________     __________________
//;_________________________________________________________________________
//;************************************************************************* */
void Flash_Refresh(uint16 start_page, uint16 end_page)
{
        do
        {
            Refresh_Page(start_page);
            start_page++;
        } while (start_page <= end_page);
        return;
}

void Sync_Refresh_Table(void)
{
    Write_Flash_Data(FLASH_FILE.file_system_start,0, (uint8 *)&FLASH_STORAGE,sizeof( FLASH_STORAGE));
}

#endif

