#include "fs_hw.h"
#include "fs_hal.h"
/*
//; Copyright (c) 1999 - 2002 Atmel Corporation  All Rights Reserved */
void Config_Spi(void)
{

    uint16 status;
    uint16 interrupt;
    uint8 i;

    file_outw(BASE_SPI_ADDRESS+SPI_STATUS_OFFSET,SPI_CONFIG1);
    file_outw(BASE_SPI_ADDRESS+SPI_CONTROL_OFFSET,SPI_CONFIG2);
    file_outw(BASE_SPI_ADDRESS+SPI_STATUS_OFFSET,(SPI_CONFIG1+SPI_ENABLE));

    /*SET UP CHIP SELECT */
    /* SETUP PORT TO NOT BE CONTROLLED BY PERIPHERAL */
    status = file_inw(SS_PER_REG);
    status = (status&(~SPI_SLAVE_SELECT)); /* CLEAR */
    file_outw(SS_PER_REG,status);

    /* SET SS PORTLINE TO BE OUTPUT */
    status = file_inw(SS_DIR_REG);
    status = (status|SPI_SLAVE_SELECT); /* A ONE TO USE AS OUTPUT */
    file_outw(SS_DIR_REG,status);

    /* SET SPI CLOCK PORTLINE TO BE OUTPUT */
    status = file_inw(CLK_DIR_REG);
    status = (status|SPI_CLOCK); /* A ONE TO USE AS OUTPUT */
    file_outw(CLK_DIR_REG,status);

    /* SET SPI CLOCK PORTLINE HIGH */
    status = file_inw(CLK_DATA_REG);
    status = (status|SPI_CLOCK); /* SET TO OUTPUT HIGH */
    file_outw(CLK_DATA_REG,status);

    /* SET SS PORTLINE HIGH */
    status = file_inw(SS_DATA_REG);
    status = (status|SPI_SLAVE_SELECT); /* SET TO OUTPUT HIGH */
    file_outw(SS_DATA_REG,status);

    /*THIS IS USED TO SETUP THE FLASH STRUCTURE */
    Query_Flash_Status();

    return;
}




void Send_Byte(uint16 data)
{
    file_outw(BASE_SPI_ADDRESS+SPI_TRANSMIT_OFFSET, data);
    Fs_Spi_Transmit_Ready();
    return;

}

uint16 Get_Byte(void)
{
    /* DUMMY READ TO CLEAR OUT THE RECEIVE BYTE READY FLAG (IF SET)*/
    file_inw(BASE_SPI_ADDRESS+SPI_RECEIVE_OFFSET);
    file_outw(BASE_SPI_ADDRESS+SPI_TRANSMIT_OFFSET, 0);
    Fs_Spi_Transmit_Ready();
    file_inw(BASE_SPI_ADDRESS+SPI_STATUS_OFFSET);
    Fs_Spi_Receive_Ready();/*WAIT UNTIL NEW BYTE HAS BEEN RECEIVED */

    /* GET NEW BYTE AND RETURN IT */
    return file_inw(BASE_SPI_ADDRESS+SPI_RECEIVE_OFFSET);
}

void Read_Data_Page(uint8 * received_data,uint16 len)
{
	uint16  i;
    /* DUMMY READ TO CLEAR OUT THE RECEIVE BYTE READY FLAG (IF SET) */
    file_inw(BASE_SPI_ADDRESS+SPI_RECEIVE_OFFSET);
    for (i = 0;i<len;i++)
    {
        file_outw(BASE_SPI_ADDRESS+SPI_TRANSMIT_OFFSET, 0);
        Fs_Spi_Receive_Ready();
        /* GET NEW BYTE */
        *received_data = file_inw(BASE_SPI_ADDRESS+SPI_RECEIVE_OFFSET);
        received_data++;
    }
    Deselect_Flash();
    return;
}


void Write_Control_Page(uint8 * transmit_data,uint16 len)
{
	uint16  i;
    for (i = 0;i<len;i++)
    {
        file_outw(BASE_SPI_ADDRESS+SPI_TRANSMIT_OFFSET, * transmit_data);
        Fs_Spi_Transmit_Ready();
        transmit_data++;
    }
    return;
}


void Write_Data_Page(uint8 * transmit_data,uint16 len)
{
    Write_Control_Page(transmit_data,len);
    Deselect_Flash();
    return;
}



void Select_Flash(void)
{
	uint16 status;
    /* SET SS PORTLINE LOW */
    status = file_inw(SS_DATA_REG);
    status = (status&(~SPI_SLAVE_SELECT)); /* SET OUTPUT LOW */
    file_outw(SS_DATA_REG,status);
}
void Deselect_Flash(void)
{
	uint16 status;
    /* SET SS PORTLINE HIGH */
    status = file_inw(SS_DATA_REG);
    status = (status|SPI_SLAVE_SELECT); /* SET TO OUTPUT HIGH */
    file_outw(SS_DATA_REG,status);
}
void Fs_Spi_Transmit_Ready(void)
{
    uint16 status;
    do
    {
        /* LOOP UNTIL THE BYTE HAS BEEN SENT OUT */
       status = file_inw(BASE_SPI_ADDRESS+SPI_STATUS_OFFSET);
    }  while ((SPI_TRANSMIT_EMPTY&status)== 0);
}

void Fs_Spi_Receive_Ready(void)
{
    uint16 status;
    do
    {
        /* LOOP UNTIL NEW BYTE HAS BEEN RECEIVED */
       status = file_inw(BASE_SPI_ADDRESS+SPI_STATUS_OFFSET);
    }  while ((SPI_RECEIVER_FULL&status)== 0);
}

void    file_outw( uint32 address, uint16 data )
{
    asm
    {
        move.l     a10,r3
        nop
        nop
        move.w     y0,x:(r3)
    }
}


uint16   file_inw( uint32 address )
{
    asm
    {
        move.l     a10,r3
        nop
        nop
        move.w     x:(r3),y0
    }

}