
#include "iomgr.h"
#include "file_api.h"

#include <stdio.h>

#define BUFFER_SIZ      80

static unsigned char write_buf[BUFFER_SIZ];
static unsigned char read_buf[BUFFER_SIZ];

/*
 *  ENTRY POINT
 */

/* --------------------------------------------------------------------------
 *
 *  main
 *
 *      Entry Point for the Simulation. 
 *
 *  Parameters:
 *      None
 *
 *  Returns:
 *      Status of Initialization - Either it Fails or Succeeds.
 *
 *
 *  Notes:
 *      None.
 *
 * --------------------------------------------------------------------------
 */

int main( int argc, char* argv[] )
{
    FILEDESC _hFile;
    int _nIdx = 0;

    char _szName[80];
    char _szNewName[80];

    /*
     *  Initialize the BUFFER
     */

    for ( _nIdx = 0; _nIdx < BUFFER_SIZ; _nIdx++ )
    {
        write_buf[ _nIdx ] = 'A' + ( _nIdx % 26 );
//        write_buf[ _nIdx ] = '0' + ( _nIdx % 10 );
    }

    /*
     *  Initialize System
     */

    IoManager_Initialize();

    /*
     *  Process Commands
     */

    for ( _nIdx = 0; _nIdx < 4; _nIdx++ )
    {
        sprintf( _szName, "C:\\test%02d.dat", _nIdx );
        sprintf( _szNewName, "coolio%02d.dat", _nIdx );
        printf( "Creating %s\n", _szName );

        _hFile = 
            sys_open( 
                _szName, 
                _OPEN_CREAT | _OPEN_RDWR | _OPEN_APPEND, 
                _S_IREAD | _S_IWRITE 
            );
        if ( _hFile == UNDEFINED_FILEDESC )
        {
            perror( "OPEN FAILED" );
            break;
        }

        /*
         *  Write some STUFF
         */

//        sys_read( _hFile, read_buf, BUFFER_SIZ );
        sys_write( _hFile, write_buf, BUFFER_SIZ );

        /*
         *  Close the FILE
         */
        sys_close( _hFile );

//        sys_rename( _szName, _szNewName );
//        sys_remove( _szName );
    }

    sprintf( _szName, "C:\\system" );
    sys_rmdir( _szName );

    /*
     *  Shutdown System
     */

    IoManager_Shutdown();

    return 0;
}