
/* Main.c
 *
 *  Test Program example for Compression
 *
 * 
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/*
 *  Compression Algorithm (defined by project or somewhere above here)
 *
 *      Necessary Header files are included in here...
 */

#if defined(_SIXPACK)
    #include "SixPack.h"
#elif defined(_LZSS)
    #include "Lzss.h"
#endif
 
/*
 *  We use the File Version (forced in the project settings)
 */

DECLARE_COMPRESS_DATA_FILE(inFP);
DECLARE_COMPRESS_DATA_FILE(outFP);

/*
 *  Global Memory
 */

#if defined( _COMPRESS_USE_STDMEMORY )

#define MemoryInit()        1
#define MemoryDestroy()

#else

static int MemoryInit( void )
{
    static char s_Memory[100000L];

    return (int)LZMemory_DefCreate( s_Memory, 100000L );
}

#define MemoryDestroy()      LZMemory_DefDestroy()

#endif

/*
 *  MAIN Program
 */

main( int argc, char* argv[] )
{
    compress_size_t _nSize;

    /*
     *  Test Argument
     */

    if ( argc < 4)
    {
        printf( "Usage: %s [+,-] inputfile outputfile\n", argv[0] );
    }
    else if ( !strcmp(argv[2],argv[3]) )
    {
        printf( "File names must be different\n" );
    }

    /* 
     *  Setup files then
     */

    else
    {
        /*
         *  Dummy Loop (avoids gotos)
         */

        do
        {
            INIT_COMPRESS_DATA_FILE(inFP, fopen( argv[2], "rb" ) );
            if ( GET_COMPRESS_DATA_FILE(inFP) == NULL )
            {
                printf("Error opening input file %s\n",argv[2]);
                break;
            }

            INIT_COMPRESS_DATA_FILE(outFP, fopen( argv[3], "wb+" ) );
            if ( GET_COMPRESS_DATA_FILE(outFP) == NULL )
            {
                printf("Error opening input file %s\n",argv[3]);
                fclose( GET_COMPRESS_DATA_FILE(inFP) );
                break;
            }

            /*
             *  File SIZE
             */

            fseek( inFP, 0L, SEEK_END );
            _nSize = ftell( inFP );

            /* 
             *  Initialize Memory
             */

            if ( MemoryInit() == 0 )
            {
                printf("Allocation of Memory Pool FAILED!\n");
            }
            else
            {
                /*
                 *  What kind of operation
                 */

                if ( *argv[1] == '+' )
                {
                    Compress( &inFP, &outFP );
                }

                else if ( *argv[1] == '-' )
                {
                    Uncompress( &inFP, &outFP );
                }

                /*
                 *  Cleanup
                 */

                MemoryDestroy();
            }

            /*
             *  Close everything
             */

            fclose(GET_COMPRESS_DATA_FILE(inFP));
            fclose(GET_COMPRESS_DATA_FILE(outFP));
        }
        while(0);
    }

    return 0;
}