
/* 
 *  Lzss.h
 *
 *  Header File for the LZSS algorithm (implemented using a Binary Tree).
 *
 */

#ifndef __LZSS_H
#define __LZSS_H

#include "Compress.h"

/*
 *  Users can set these parameters as they need. We use equates to limit the 
 *  amount of memory resources required.
 */


#define N               4096        /* Size of ring buffer              */
#define F               18	        /* Upper limit for match_length     */

#define THRESHOLD       2           /* Encode string into position and  *
                                     * length if match_length is        *
                                     * greater than this                */

#define NIL             N           /* Index for root of binary search  *
                                     * trees.                           */

#endif      /* Lszz.h   */
