


/* LZMemory.h
 *
 *      DSPOS Memory Manager for Console Command Processor Public Interfaces
 *
 * Copyright (c) 2000-2001 Telchemy, Inc.
 */

#ifndef __LZMEMORY_H
#define __LZMEMORY_H

/*
 *  Local Types
 */

typedef unsigned char*  LZMEMORY_BYTEPTR;

/*
 *  Just in case size_t is no where to be found
 */

#ifndef _SIZE_T_DEFINED
    typedef unsigned int size_t;
    #define _SIZE_T_DEFINED
#endif

/*
 *  Constants and forward refernces
 */

#ifdef __cplusplus
    struct LZMemory;
#else
    typedef struct LZMemory* LZMemory;
#endif

#define LZMEMORY_STAT           0x80000000L
#define LZMEMORY_NULL           (LZMemory)0

/* --------------------------------------------------------------------------
 *
 *      LZMemory Object Type
 *
 * --------------------------------------------------------------------------
 */

struct LZMemory
{
    size_t size;

#ifdef __cplusplus
    LZMemory* next;
#else
    LZMemory next;
#endif

};

/* --------------------------------------------------------------------------
 *
 *      LZMemory Object API
 *
 * --------------------------------------------------------------------------
 */

/*
 *  Constructor/Destructor
 */

LZMemory LZMemory_Construct( void* memory, size_t size );
void LZMemory_Destroy( LZMemory This );

/*
 *  Methods
 */

void* LZMemory_Allocate( LZMemory This, size_t size );
void LZMemory_Deallocate( LZMemory This, void* memory );

/*
 *  Static Methods (no This pointer)
 */

void* LZMemory_Copy( void *dest, const void *src, size_t count );
void* LZMemory_Set( void *dest, int c, size_t count );

/* --------------------------------------------------------------------------
 *
 *      GLOBAL Memory Pool and Macros...
 *
 * --------------------------------------------------------------------------
 */

/*
 *  Global Memory Pool (Optional)
 */

extern LZMemory g_LZMemPool;

/*
 *  Default Memory Pool initialization
 */

#define LZMemory_DefCreate(mem,siz) \
    ( g_LZMemPool = LZMemory_Construct( (mem), (siz) ) )

#define LZMemory_DefDestroy() \
    ( LZMemory_Destroy( g_LZMemPool ) )

/*
 *  Method Overloads
 */

#if !defined(_INC_MALLOC) && !defined(_INC_STDLIB)

    #define malloc( size ) \
        LZMemory_Allocate( g_LZMemPool, size )

    #define free( mem ) \
        LZMemory_Deallocate( g_LZMemPool, mem )

    #define _INC_MALLOC
    #define _INC_STDLIB

#endif

/*
 *  Static Overloads
 */

#if !defined(_INC_MEMORY) && !defined(_INC_STRING)

    #define memcpy( src, dst, count ) \
        LZMemory_Copy( src, dst, count )

    #define memset( src, c, count ) \
        LZMemory_Set( src, c, count )

    #define _INC_MEMORY
    #define _INC_STRING

#endif

#endif  /* __LZMEMORY_H */
