#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include "dspos.h"
#include "utility.h"

// Forward Declarations
void initialize_simple_test();
void cleanup_simple_test();

// Constants
#define EXAMPLE_MSG "Nervously I loaded the twin ducks aboard the revolving platform."
//#define EXAMPLE_MSG "Nervously I loaded the twin"
//#define EXAMPLE_MSG "Nervously I loaded"
#define EXAMPLE_MSG_SIZE sizeof(EXAMPLE_MSG)

int doSimpleTest()
{
   unsigned char syndrome[SYNDROME_LENGTH];

   // Setup the example's data structures
   initialize_simple_test();

   // Initilize Error-Correcting SubSystem
   initialize_ecc();

   // Print the buffer
   printf("\"%s\"\n", msg_original);
   print_buffer(msg_original, msg_original_length);

   // Reset our data pointers
   msg_original_ptr = msg_original;
   msg_encoded_ptr  = msg_encoded;

   // Encode the msg buffer
   while (msg_original_length > 0)
   {
      encode_data(msg_original_ptr, 
                  (msg_original_length >= DECODED_DATA_SIZE ? DECODED_DATA_SIZE : msg_original_length), 
                  msg_encoded_ptr);
      msg_original_ptr    += DECODED_DATA_SIZE; 
      msg_original_length -= DECODED_DATA_SIZE; 
      msg_encoded_ptr     += ENCODED_DATA_SIZE;
   }

   // Print the buffer
   print_encoded_buffer(msg_encoded, msg_encoded_length);
   print_buffer(msg_encoded, msg_encoded_length);

   // Reset our data pointers
   msg_encoded_ptr = msg_encoded;
   msg_decoded_ptr = msg_decoded;

   // Introduce some errors
   msg_encoded_ptr[2]  ^= 0x35;
   msg_encoded_ptr[30] ^= 0x35;
   msg_encoded_ptr[39] ^= 0x23;
   msg_encoded_ptr[49] ^= 0x34;
   msg_encoded_ptr[68] ^= 0x34;
   msg_encoded_ptr[75] ^= 0x34;

   // Print the buffer
   print_encoded_buffer(msg_encoded, msg_encoded_length);
   print_buffer(msg_encoded, msg_encoded_length);

   // Decode the codeword buffer
   while (msg_encoded_length > 0)
   {
      if (decode_data(msg_encoded_ptr, syndrome) != 0)
      {
         printf("DECODE ERROR!\n\n");
	      if (correct_errors(msg_encoded_ptr, syndrome) != 0)
         {
	         /* Uh-oh! Unrecoverable bad data! */
            printf("UNRECOVERABLE ERRORS!\n\n");
         }
      }

      memcpy(msg_decoded_ptr, msg_encoded_ptr, DECODED_DATA_SIZE);

      msg_decoded_ptr    += DECODED_DATA_SIZE; 
      msg_encoded_length -= ENCODED_DATA_SIZE; 
      msg_encoded_ptr    += ENCODED_DATA_SIZE;
   }

   // Print the buffer
   printf("\"%s\"\n", msg_decoded);
   print_buffer(msg_decoded, msg_original_length);

   cleanup_simple_test();

   printf("Simple Test: All Done!\n");
   return 0;
}

void initialize_simple_test()
{
   int i, msg_length_rounded, pad;

   /* The msg buffer might be bigger than the actually message,
      because when decoding, ENCODED_DATA_SIZE bytes goes into
      DECODED_DATA_SIZE bytes thus the msg buffer must be a multiple
      of DECODED_DATA_SIZE bytes. The method calcSizeOfDecodedBuffer
      will round up to the first multiple of DECODED_DATA_SIZE.
   */
   msg_original_length = EXAMPLE_MSG_SIZE;
   msg_length_rounded = calcSizeOfDecodedBuffer(msg_original_length);
   msg_original = (unsigned char*) malloc(msg_length_rounded);
   msg_decoded  = (unsigned char*) malloc(msg_length_rounded);
   if (strlen(EXAMPLE_MSG) != 0)
   {
      memcpy(msg_original, EXAMPLE_MSG, EXAMPLE_MSG_SIZE);
      pad = msg_length_rounded - EXAMPLE_MSG_SIZE;
      if (pad > 0)
      {
         memset(&msg_original[EXAMPLE_MSG_SIZE], 0, msg_length_rounded - EXAMPLE_MSG_SIZE);
      }
   }
   else
   {
      for (i = 0; i < msg_original_length; i++) msg_original[i] = i;
   }

   msg_encoded_length = calcSizeOfEncodedBuffer(msg_original_length);
   msg_encoded = (unsigned char*) malloc(msg_encoded_length);
}

void cleanup_simple_test()
{
   free(msg_original);
   free(msg_encoded);
}

