#ifndef REED_SOLOMON_H
#define REED_SOLOMON_H

#define byte unsigned char


 /************ CONFIGURATION PARAMATERS ******************/

  /********** DEBUG *********************/
 /* THE RS_DEBUG DEFINE WILL TURN ON PRINTING WHEN */
 /* WHEN AN UNCORRECTABLE ERROR IS DETECTED */
 /*#define RS_DEBUG */

#ifdef RS_DEBUG

#include <stdio.h>

#endif
/******** Memory routines **************/

/* USE THE DEFAULT "memory.h" FILE FOR MEMORY COPY AND MEMSET */
/* #define MEMORY_ROUTINES_USE_MEMORY_H */

/* USE THE SLOW SUPPLIED MEMORY COPY AND MEMORY SET FUNCTIONS */
#define MEMORY_ROUTINES_USE_SIMPLE_IMPL

/* USE THE DSP OS FUNCTIONS */
/* #define MEMORY_ROUTINES_USE_DSP_OS */

/* ***************************************************************************** */
/* THE 8 GEN POLY DEFINES FOR RS(32,28)                                                */
/* ***************************************************************************** */
#define     GEN_POLY0               0x74
#define     GEN_POLY1               0xE7
#define     GEN_POLY2               0xD8
#define     GEN_POLY3               0x1E
#define     GEN_POLY4               0x01
#define     GEN_POLY5               0
#define     GEN_POLY6               0
#define     GEN_POLY7               0





/* Constants */
#define DECODED_DATA_SIZE       28 /* bytes */
#define ENCODED_DATA_SIZE       32 /* bytes */
#define NUM_PARITY_BYTES        (ENCODED_DATA_SIZE - DECODED_DATA_SIZE) /* bytes */
#define MAX_CORRECTABLE_ERRORS  NUM_PARITY_BYTES / 2 /* errors */
#define SYNDROME_LENGTH         NUM_PARITY_BYTES * 2 /* bytes */
#define POLY_SIZE               NUM_PARITY_BYTES * 2 /* bytes */
#define DOUBLE_POLY_SIZE        POLY_SIZE * 2 /* bytes */

/* Static Buffers */
extern byte exp_table[512];
extern byte log_table[256];
extern byte gen_poly[DOUBLE_POLY_SIZE];

/* Call once at the beginning of time, initializes lookup tables. */
extern void initialize_ecc();

/* Call to encode up to 28 msg bytes into a 32 byte codeword. */
extern void encode_data(byte msg[], int msg_length, byte codeword[]);

/* Call to decode the 32 byte codeword and fill an 8 byte syndrome.
   Returns zero if the data was decoded with no errors, non-zero if there were errors. */
extern int decode_data(byte codeword[], byte syndrome[]);

/* Call to in-place correct errors in a 32 byte codeword.
   Returns zero if everything was ok, non-zero if there was an out-of-bounds error.*/
extern int correct_errors(byte codeword[], byte syndrome[]);

/* Fast Multiplication with logarithms */
#define fast_mult(a,b) ((a==0 || b == 0) ? 0 : exp_table[log_table[a] + log_table[b]])

#define fast_inv(elt) (exp_table[255 - log_table[elt]])
#define zero_poly(poly, size) MEMSET(poly, 0, size)
#define copy_poly(dst, src, size) MEMCPY(dst, src, size)




#ifdef MEMORY_ROUTINES_USE_MEMORY_H
   #include <memory.h>
   #define MEMSET(__buf, __value, __length) memset(__buf, __value, __length);
   #define MEMCPY(__dest, __src, __length) memcpy(__dest, __src, __length);
#endif

#ifdef MEMORY_ROUTINES_USE_DSP_OS
   #include <dsp_os.h>
void  rs_memset(unsigned char * destination,unsigned char value, int size);
   #define MEMSET(__buf, __value, __length) rs_memset(__buf, __value, __length);
   #define MEMCPY(__dest, __src, __length) Os_Byte_Memcpy( __src,__dest, __length);
#endif

#ifdef MEMORY_ROUTINES_USE_SIMPLE_IMPL
void  rs_memcpy(unsigned char * destination,unsigned char * source, int size);
void  rs_memset(unsigned char * destination,unsigned char value, int size);
   #define MEMSET(__buf, __value, __length) rs_memset(__buf, __value, __length);
   #define MEMCPY(__dest, __src, __length) rs_memcpy(__dest, __src, __length);

#endif






/* Forward Declarations */
void rs_init(void);
void mult_polys (byte dst[], byte p1[], byte p2[]);
void Modified_Berlekamp_Massey(byte syndrome[], byte lambda[], byte omega[]);
int Find_Roots(byte lambda[], byte error_locations[]);
byte compute_discrepancy(byte lambda[], byte syndrome[], int L, int n);
void mul_z_poly(byte src[]);
void compute_modified_omega(byte syndrome[], byte lambda[], byte omega[]);

#endif

